/*****************************************************************************
 *		This is the hardware interface header file
 *		#include files here that have the definitions for the hardware
 */
 
//#include "uexec.h"
#include <hcs12dp256.h>
#include <project.h>
#include <SPIdp.h>

/*	Hardware dependent definations	*/
/*	MMCard power control	*/
#define MMCardPwrCtlPin		0x01
#define MMCardPwrCtlPort	PTK
#define MMCardPwrCtlDDR		DDRK
/*	The rest follows	*/
#define INITCardPwrCtlPin	MMCardPwrCtlPort BitOff MMCardPwrCtlPin; MMCardPwrCtlDDR BitOn MMCardPwrCtlPin;
#define MMCardPwrON			MMCardPwrCtlPort BitOn  MMCardPwrCtlPin;
#define MMCardPwrOFF		MMCardPwrCtlPort BitOff  MMCardPwrCtlPin;
#define MMCardPwrQuy(State)		if(MMCardPwrCtlPort & MMCardPwrCtlPin) { State = 1;} else {State = 0;}
			
/*	MMCard card detection	*/
#define MMCardDetectPin		0x10
#define MMCardDetectPort	PTP
#define MMCardDetectDDR		DDRP
/*	The rest Follows	*/
#define INITCardDetect	MMCardDetectDDR	BitOff MMCardDetectPin;
#define CardPresent		(!(MMCardDetectPort & MMCardDetectPin))

/*	MMCard SPI defines	*/
#define MMCardSPIPort		PTS
#define MMCardSPIPortDDR	DDRS
#define MMCardSPIMod	0

/*	Definitions to replace the function names of the 
 *	SPI routines with the correct module name	*/
#define InitMMCardSPI InitSPI0
#define SendGetMMCardSPI SendGetSPI0
#define SendGetMMCardSPIWord SendGetSPI0Word
/*	If hardware uses the SS output. 
 *	(as the VESI.pcb and the PDAPOD does).
 *	then the following should be defined as null.
 *	Otherwise define as required.
 */
#define MMCard_CS_PORT	PTS
#define MMCard_CS_DDR	DDRS
#define MMCard_CS_PIN	0x08
/*	Then the rest follows	*/
#define INIT_MMCARD_CS		MMCard_CS_PORT BitOn MMCard_CS_PIN; MMCard_CS_DDR BitOn MMCard_CS_PIN;
#define ASSERT_MMCard_CS	MMCard_CS_PORT BitOff MMCard_CS_PIN;
#define DEASSERT_MMCard_CS	MMCard_CS_PORT BitOn MMCard_CS_PIN;

/*	Macro for delay used in MMCard routines
 *	Code as required for operating system or implementation
 */
/*	PDAPOD using the UEXEC RTOS from IMAGECRAFT	*/
//#define MMCardDelay(Count)	while(Count--){UEXC_Defer();} // Count off the task round robin loops

/*	Standard simple delay	*/
#define MMCardDelay(Count) {uint16	x,i; for(i=0;i<Count;i++)	{for(x=0;x<1000;x++){;}	} }


